<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Low Stock Alert</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .logo {
            max-height: 50px;
        }

        h1 {
            color: #d9534f;
            font-size: 24px;
            margin-bottom: 20px;
        }

        .stock-info {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }

        .stock-info p {
            margin: 5px 0;
        }

        .button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #d9534f;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            margin: 20px 0;
        }

        .footer {
            margin-top: 30px;
            font-size: 12px;
            color: #777;
            text-align: center;
        }
    </style>
</head>

<body>
    <div class="header">
        @if ($logo = config('mail.logo'))
            <img src="{{ $logo }}" alt="{{ config('app.name') }}" class="logo">
        @else
            <h2>{{ config('app.name') }}</h2>
        @endif
    </div>

    <h1>Low Stock Alert: {{ $ingredient->getTranslation('name', 'en') }}</h1>

    <p>The stock level for <strong>{{ $ingredient->getTranslation('name', 'en') }}</strong> is below 50%.</p>

    <div class="stock-info">
        <p><strong>Current Stock:</strong> {{ $ingredient->current_stock }}{{ $ingredient->unit }}</p>
        <p><strong>Initial Stock:</strong> {{ $ingredient->initial_stock }}{{ $ingredient->unit }}</p>
        <p><strong>Percentage Remaining:</strong>
            {{ round(($ingredient->current_stock / $ingredient->initial_stock) * 100, 2) }}%</p>
    </div>

    <p>Please order more stock as soon as possible to avoid running out.</p>



    <div class="footer">
        <p>© {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
        <p>This is an automated notification - please do not reply to this email.</p>
    </div>
</body>

</html>
