<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            'general_settings' => [
                ['key' => 'company_name', 'value' => null],
                ['key' => 'website_title', 'value' => null],
                ['key' => 'name_of_rights', 'value' => null],
                ['key' => 'website_address', 'value' => null],
                ['key' => 'website_description', 'value' => null,'type' => 'textarea'],
                ['key' => 'meta_description', 'value' => null,'type' => 'textarea'],
            ],

            'properties' => [
                ['key' => 'website_logo_large', 'value' => null, 'type' => 'imageUploader'],
                ['key' => 'website_logo_small', 'value' => null, 'type' => 'imageUploader'],
                ['key' => 'website_logo_login', 'value' => null, 'type' => 'imageUploader'],
                ['key' => 'website_logo_home_page', 'value' => null, 'type' => 'imageUploader'],
                ['key' => 'website_logo_notification', 'value' => null, 'type' => 'imageUploader'],
                ['key' => 'website_favorite_place_icon', 'value' => null, 'type' => 'imageUploader'],
            ],


            'notifications' => [
                ['key' => 'mail_support', 'value' => true,'type' => 'toggle'],
                ['key' => 'sms_support', 'value' => true ,'type' => 'toggle'],
                ['key' => 'push_support', 'value' => true,'type' => 'toggle'],
                ['key' => 'real_time_support', 'value' => true,'type' => 'toggle'],
            ],

            'site_content.home'=>[
                ['key' => 'home_title', 'value' => null],
                ['key' => 'home_description', 'value' => null],
                ['key' => 'home_image', 'value' => null, 'type' => 'imageUploader'],
            ],

            'site_content.contact'=>[
                ['key' => 'description', 'value' => null,'type' => 'textarea'],
                ['key' => 'email', 'value' => null],
                ['key' => 'phone', 'value' => null],
                ['key' => 'address', 'value' => null],
                ['key' => 'facebook', 'value' => null],
                ['key' => 'twitter', 'value' => null],
                ['key' => 'linkedin', 'value' => null],
                ['key' => 'instagram', 'value' => null],
                ['key' => 'youtube', 'value' => null],
            ],

            'site_content.terms_and_conditions'=>[
                ['key' => 'agreeing_to_all', 'value' => 'test'],
                ['key' => 'appointment_rules_regulations', 'value' => 'test'],
                ['key' => 'ruling_regime', 'value' => 'test'],
                ['key' => 'patients_bill_of_rights', 'value' => 'test'],
                ['key' => 'disclaimer', 'value' => 'test'],
                ['key' => 'potential_risks', 'value' => 'test'],

            ],

            'site_content.how_to_work'=>
            [
                ['key' => 'title', 'value' => 'test'],
                ['key' => 'description', 'value' => null,'type' => 'textarea'],
            ],


            'site_content.about_us'=>
            [
                ['key' => 'title', 'value' => 'test'],
                ['key' => 'description', 'value' => null,'type' => 'textarea'],
                ['key' => 'image', 'value' => null, 'type' => 'imageUploader'],
            ],

            'site_content.knowledge_center'=>
            [
                ['key' => 'title', 'value' => 'test'],
                ['key' => 'description', 'value' => null,'type' => 'textarea'],
                ['key' => 'image', 'value' => null, 'type' => 'imageUploader'],
            ],

            'site_content.about_us'=>
            [
                ['key' => 'title', 'value' => 'test'],
                ['key' => 'description', 'value' => null,'type' => 'textarea'],
                ['key' => 'image', 'value' => null, 'type' => 'imageUploader'],
            ],

            'site_content.our_vision'=>
            [
                ['key' => 'description', 'value' => null,'type' => 'textarea'],
            ],

            'site_content.general_goal'=>
            [
                ['key' => 'description', 'value' => null,'type' => 'textarea'],
            ],

            'site_content.our_values'=>
            [
                ['key' => 'description', 'value' => null,'type' => 'textarea'],
            ],

            'site_content.our_message'=>
            [
                ['key' => 'description', 'value' => null,'type' => 'textarea'],
            ],

            'site_content.stratagic_goals'=>
            [
                ['key' => 'description', 'value' => null,'type' => 'textarea'],
            ],


            // 'contacts' => [
            //     ['key' => 'email', 'value' => null],
            //     ['key' => 'phone', 'value' => null],
            //     ['key' => 'address', 'value' => null],
            // ],


            // 'notifications' => [
            //     ['key' => 'mail_support', 'value' => true,'type' => 'toggle'],
            //     ['key' => 'sms_support', 'value' => true ,'type' => 'toggle'],
            //     ['key' => 'push_support', 'value' => true,'type' => 'toggle'],
            //     ['key' => 'real_time_support', 'value' => true,'type' => 'toggle'],
            // ],

            // 'social_media' => [
            //     ['key' => 'facebook', 'value' => null],
            //     ['key' => 'twitter', 'value' => null],
            //     ['key' => 'linkedin', 'value' => null],
            //     ['key' => 'instagram', 'value' => null],
            //     ['key' => 'youtube', 'value' => null],
            // ],

            // 'theme' => [
            //     ['key' => 'primary_color', 'value' => null],
            //     ['key' => 'font_family_ar', 'value' => null, 'type' => 'select'],
            //     ['key' => 'font_family_en', 'value' => null, 'type' => 'select'],
            //     ['key' => 'font_size', 'value' => null, 'type' => 'select'],
            // ],

            // 'terms_and_conditions' => [
            //     ['key' => 'agreeing_to_all', 'value' => 'test'],
            //     ['key' => 'appointment_rules_regulations', 'value' => 'test'],
            //     ['key' => 'ruling_regime', 'value' => 'test'],
            //     ['key' => 'patients_bill_of_rights', 'value' => 'test'],
            //     ['key' => 'disclaimer', 'value' => 'test'],
            //     ['key' => 'potential_risks', 'value' => 'test'],
            // ],

            'mail_server' => [
                ['key' => 'mail_mailer', 'value' => null, 'is_env' => true],
                ['key' => 'mail_host', 'value' => null, 'is_env' => true],
                ['key' => 'mail_port', 'value' => null, 'is_env' => true],
                ['key' => 'mail_username', 'value' => null, 'is_env' => true],
                ['key' => 'mail_password', 'value' => null, 'is_env' => true],
                ['key' => 'mail_encryption', 'value' => null, 'is_env' => true],
                ['key' => 'mail_from_address', 'value' => null, 'is_env' => true],
                ['key' => 'mail_from_name', 'value' => null, 'is_env' => true],
            ],
        ];

        foreach ($settings as $group => $groupSettings) {
            foreach ($groupSettings as $setting) {
                Setting::create(array_merge(['group' => $group], $setting));
            }
        }
    }
}
