<?php

namespace Database\Seeders;

use App\Models\Client;
use App\Models\Customer;
use App\Models\Employee;
use App\Models\Supplier;
use App\Models\ClientAddress;
use App\Enums\EmployeeTypeEnum;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Services\Global\RoleService;
use Illuminate\Database\Eloquent\Model;

class RolesAndPermissionsSeeder extends Seeder
{
    public function run()
    {
        Model::unguard();

        // Remove the relationships from pivot tables
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('model_has_roles')->truncate();
        DB::table('model_has_permissions')->truncate();
        DB::table('role_has_permissions')->truncate();
        DB::table('permissions')->truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        (new RoleService())->handle();

        Employee::query()->firstOrCreate([
            'email' => 'root@root.com',
        ], [
            'name' => 'root',
            'password' => '123456',

        ])->assignRole('root');

        Employee::query()->firstOrCreate([
            'email' => 'admin@admin.com',
        ], [
            'name' => 'admin',
            'password' => '123456',

        ])->assignRole('admin');

        $customers = [
            [
                'name' => 'Customer One',
                'email' => 'customerone@example.com',
                'phone' => '123456789',
                'password' => '123456',
            ],
            [
                'name' => 'Customer Two',
                'email' => 'customertwo@example.com',
                'phone' => '987654321',
                'password' => '123456',
            ],
        ];

        foreach ($customers as $customer) {
            Customer::create($customer);
        }


    }
}