<?php

namespace Database\Seeders;
use App\Models\Category;
use App\Models\Employee;
use App\Models\Product;
use Illuminate\Database\Seeder;
use Illuminate\Http\UploadedFile;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $employeeId = Employee::inRandomOrder()->value('id') ?? 1;
        $categoryId = Category::inRandomOrder()->value('id') ?? null;

        if (!$categoryId) {
            $this->command->warn('No categories found. Skipping ProductSeeder.');
            return;
        }

        $products = [
            [
                'name' => ['en' => 'Wireless Mouse', 'ar' => 'فأرة لاسلكية'],
                'description' => ['en' => 'Ergonomic design', 'ar' => 'تصميم مريح'],
            ],
            [
                'name' => ['en' => 'Office Chair', 'ar' => 'كرسي مكتب'],
                'description' => ['en' => 'Comfortable and adjustable', 'ar' => 'مريح وقابل للتعديل'],
            ],
            [
                'name' => ['en' => 'Programming Book', 'ar' => 'كتاب برمجة'],
                'description' => ['en' => 'Learn Laravel step by step', 'ar' => 'تعلم لارافيل خطوة بخطوة'],
            ],
        ];

        foreach ($products as $data) {
            $product = Product::create(array_merge($data, [
                'created_by' => $employeeId,
                'category_id' => $categoryId,
            ]));

            // Optionally attach some fake files
            $product->syncFiles([
                new UploadedFile(
                    public_path('dummy.pdf'), // You need to place a dummy.pdf here
                    'manual.pdf',
                    'application/pdf',
                    null,
                    true
                ),
            ]);
        }
    }
}
