<?php

namespace App\Services\API\Order;

use App\Events\IngredientStockLow;
use App\Models\Ingredient;
use App\Models\Product;

class StockService
{
    public function updateIngredientsStock(array $orderedProducts): void
    {
        foreach ($orderedProducts as $productItem) {
            $product = Product::with('ingredients')->find($productItem['product_id']);
            // dd($product);
            foreach ($product->ingredients as $ingredient) {
                $this->updateIngredientStock($ingredient, $productItem['quantity']);
            }
        }
    }

    private function updateIngredientStock(Ingredient $ingredient, int $quantity): void
    {
        $consumedAmount = $ingredient->pivot->amount * $quantity;
        $ingredient->decrement('current_stock', $consumedAmount);

        if ($this->shouldNotifyLowStock($ingredient)) {
            event(new IngredientStockLow($ingredient));
            $ingredient->update(['low_stock_notification_sent' => true]);
        }
    }

    private function shouldNotifyLowStock(Ingredient $ingredient): bool
    {
        return $ingredient->isStockBelowThreshold()
            && !$ingredient->low_stock_notification_sent;
    }
}
