<?php

namespace App\Models;

use App\Services\Global\UploadService;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
// use Spatie\Activitylog\Traits\LogsActivity;

class Setting extends Model
{
    // use LogsActivity;

    public bool $inPermission = true;
    public array $basicOperations = ['read', 'update'];
    protected $fillable = ['key', 'value', 'group', 'model', 'is_env', 'type'];

    /*
     |--------------------------------------------------------------------------
     | Set Custom Attributes
     |--------------------------------------------------------------------------
    */
    public function value(): Attribute
    {
        return Attribute::make(
            get: fn($value) => in_array($this->type, ['imageUploader', 'file']) ? UploadService::url($value) : $value
        );
    }


}