<?php

namespace App\Models;

use App\Services\Global\UploadService;
use App\Trait\Global\CreatedByObserver;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class Product extends Model
{
    use HasFactory, HasTranslations, SoftDeletes, CreatedByObserver;

    protected $fillable = ['name', 'description', 'created_by', 'category_id'];

    public array $translatable = ['name', 'description'];
    public bool $inPermission = true;


    public function syncFiles(array $files, $is_update = false): void
    {
        if (!empty($files)) {
            if ($is_update) {
                $this->files()->delete();
            }

            $this->files()->createMany(
                collect($files)
                    ->map(
                        fn($file) => [
                            'name' => $file->getClientOriginalName(),
                            'path' => UploadService::store($file, 'Product'),
                        ],
                    )
                    ->toArray(),
            );
        }
    }


    public function creator(): BelongsTo
    {
        return $this->belongsTo(Employee::class, 'created_by');
    }

    public function files(): MorphMany
    {
        return $this->morphMany(File::class, 'fileable');
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class, 'category_id');
    }
}
