<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Ingredient extends Model
{

    use HasFactory, HasTranslations;

    protected $fillable = [
        'name',
        'unit',
        'current_stock',
        'initial_stock',
        'low_stock_notification_sent'
    ];

    protected $casts = [
        'low_stock_notification_sent' => 'boolean'
    ];

    public array $translatable = ['name'];
    public bool $inPermission = true;


    public function products(): BelongsToMany
    {
        return $this->belongsToMany(Product::class)
            ->withPivot('amount')
            ->withTimestamps();
    }

    public function isStockBelowThreshold(): bool
    {
        // dd($this->current_stock / $this->initial_stock , ($this->current_stock / $this->initial_stock) < 0.5);
        return ($this->current_stock / $this->initial_stock) < 0.5;
    }
}