<?php

namespace App\Models;

use App\Enums\EmployeeStatusEnum;
use Laravel\Sanctum\HasApiTokens;
use App\Services\Global\UploadService;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Database\Eloquent\Casts\Attribute;
use App\Notifications\UserPasswordResetNotification;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Authenticatable
{
    use HasFactory, HasApiTokens ,SoftDeletes, HasRoles;

    protected string $guard_name = 'sanctum';
    protected $guard = 'employee';

    public bool $inPermission = true;

    protected $fillable = [
        'name', 'email', 'password', 'avatar', 'phone', 'address', 'type'
    ];


    protected $hidden = ['password'];
    protected $casts = [
        'status' => EmployeeStatusEnum::class,
     ];

    /*
    |--------------------------------------------------------------------------
    | Casts && Set Custom Attributes
    |--------------------------------------------------------------------------
    */
    protected function casts(): array
    {
        return [
            'password' => 'hashed',
        ];
    }

    public function suppliedProducts()
    {
        return $this->belongsToMany(Product::class, 'product_suppliers', 'supplier_id', 'product_id')
                    ->withPivot('barcode')
                    ->withTimestamps();
    }
    // public function avatar(): Attribute
    // {
    //     return Attribute::make(
    //         get: static fn($value) => UploadService::url($value)
    //     );
    // }

    // protected function password(): Attribute
    // {
    //     return Attribute::make(set: static fn($value) => bcrypt($value));
    // }

    /*
    |--------------------------------------------------------------------------
    | Helper methods
    |--------------------------------------------------------------------------
    */
    // public function sendPasswordResetNotification($token): void
    // {
    //     $this->notify(new UserPasswordResetNotification($token));
    // }
    /*
    |--------------------------------------------------------------------------
    | Relations methods
    |--------------------------------------------------------------------------
    */

    public function creator(): BelongsTo
    {
        return $this->belongsTo(__CLASS__, 'created_by');
    }

}