<?php

namespace App\Http\Resources\API\Order;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'product_id' => $this->product_id,
            'product_name' => $this->product_name,
            'barcode' => $this->barcode,
            'price' => $this->price,
            'quantity' => $this->quantity,
            'discount' => $this->discount,
            'discount_type' => $this->discount_type,
            'total' => $this->total,

            'images' => $this->product ? $this->product->files->pluck('path') : [],

            'images' => $this->product
            ? $this->product->files->map(fn($file) => asset(Storage::url($file->path)))
            : [],
        ];
    }
}
