<?php

namespace App\Http\Resources\API;

use Illuminate\Http\Request;
use App\Enums\EmployeeTypeEnum;
use Illuminate\Support\Facades\Storage;
use App\Http\Resources\Employee\RoleResource;
use Illuminate\Http\Resources\Json\JsonResource;

class EmployeeResource extends JsonResource
{
    /**
     * @param Request $request
     * @return array
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'avatar' => $this->avatar ? asset(Storage::url($this->avatar)) : null,
            'role' => $this->roles->first() ? new RoleResource($this->roles->first()) : null,
            'created_at' => $this->created_at?->toDateTimeString(),
        ];
    }
}
