<?php

namespace App\Http\Requests\Auth;

use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{




    public function rules(): array
    {
        return [
            'email' => [
                'required_if:userType,employee',
                'nullable',
                'email',
            ],
            'phone' => [
                'required_if:userType,client,email,null',
                'nullable',
                'regex:/^\+?[1-9]\d{1,14}$/',
            ],
            // 'type' => [
            //     'required',
            //     'in:client,employee',
            // ]

        ];
    }
}