<?php

namespace App\Http\Requests\API\Slider;

use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SliderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, ValidationRule|array|string>
     */
    public function rules(): array
    {
        $slider = $this->route('slider');

        return [
            'title.ar' => ['nullable', Rule::unique('sliders', 'title->ar')->whereNull('deleted_at')->ignore($slider)],
            'title.en' => ['nullable', Rule::unique('sliders', 'title->en')->whereNull('deleted_at')->ignore($slider)],
            'image' => [
                $slider && $slider->image ? 'nullable' : 'required'
            ],
            'description.ar' => ['nullable'],
            'description.en' => ['nullable'],
        ];
    }
}
