<?php

namespace App\Http\Requests\API;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class ProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name.ar' => ['required', Rule::unique('products', 'name->ar')->whereNull('deleted_at')->ignore($this->route('product'))],
            'name.en' => ['nullable', Rule::unique('products', 'name->en')->whereNull('deleted_at')->ignore($this->route('product'))],

            'category_id' => ['required', Rule::exists('categories', 'id')],
            'description.ar' => ['nullable'],
            'description.en' => ['nullable'],

            'files' => 'nullable|array',
            'files.*' => 'file|mimes:jpg,jpeg,png,pdf|max:2048',
        ];
    }
}
