<?php

namespace App\Http\Requests\API\Order;

use App\Enums\OrderStatusEnum;
use App\Enums\PaymentMethodEnum;
use App\Enums\PaymentStatusEnum;
use App\Rules\ProductBelongsToOrder;
use Illuminate\Validation\Rules\Enum;
use Illuminate\Foundation\Http\FormRequest;

class UpdateOrderDetailsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'order_status' => ['nullable', new Enum(OrderStatusEnum::class)],
            'payment_method' => ['nullable', new Enum(PaymentMethodEnum::class)],
            'payment_status' => ['nullable', new Enum(PaymentStatusEnum::class)],
            'delegate_id' => 'nullable|exists:employees,id',
            'items' => 'nullable|array',
            'items.*.id' => [
                'required_with:items',
                'exists:products,id',
                new ProductBelongsToOrder($this->route('order')->id),
            ],
            'items.*.quantity' => 'required_with:items|integer|min:1',


        ];
    }
}
