<?php

namespace App\Http\Requests\API;

use App\Enums\EmployeeTypeEnum;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Enum;
use Illuminate\Foundation\Http\FormRequest;

class EmployeeRequest extends FormRequest
{
    public function rules(): array
    {
        $employeeId = $this->route('employee') ? $this->route('employee')->id : null;

        $rules = [
            'name'        => 'required|string|max:255',
            'email' => [
                'required',
                'email',
                Rule::unique('employees', 'email')->ignore($employeeId),
            ],
            'password'    => 'required|min:6',
            'phone'       => [
                'nullable',
                'string',
                Rule::unique('employees', 'phone')->ignore($this->route('employee')),
            ],
            'avatar'      => 'sometimes|nullable|' . v_image(),
            // 'role'       => ['required', 'array'],
            'role'        => ['required', 'integer', Rule::exists('roles', 'id')],

            // 'role'     => ['required', Rule::exists('roles', 'name')],
            'permissions' => 'nullable|array',
            'permissions.*' => 'required_with:permissions|exists:permissions,name',
         ];


        return $rules;
    }
}
