<?php

namespace App\Http\Requests\API\Customer;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class CustomerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'email'       => [
                'required',
                'email',
                Rule::unique('customers', 'email')->ignore($this->route('customer')),
            ],
            'password' => ['required',   'min:6','string'],
            'phone' => 'nullable|string|max:20',
        ];
    }
}
