<?php

namespace App\Http\Middleware;

use App\Models\Setting;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckMaxRequestLimit
{
    /**
     * Handle an incoming request.
     *
     * @param Closure(Request): (Response) $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (!$user = auth('api')->user()) {
            return response()->json(['message' => __('api.unauthorized')], 401);
        }

        $defaultMaxRequests = Setting::where('key', 'max_request_number')->value('value');

        $allowedRequests = $user->max_request_number ?? $defaultMaxRequests;

        if (is_null($allowedRequests)) {
            return $next($request);
        }

        if ($user->requests()->count() < (int)$allowedRequests) {
            return $next($request);
        }

        return response()->json(['message' => __('api.max_requests_reached')], 403);
    }
}
