<?php

namespace App\Http\Controllers\API\Web;

use App\Http\Resources\API\Slider\SliderResource;
use App\Models\Product;
use App\Models\Slider;
use Illuminate\Http\JsonResponse;
use Illuminate\Pipeline\Pipeline;
use App\Filters\Global\NameFilter;
use App\Http\Controllers\Controller;
use App\Filters\Global\OrderByFilter;
use App\Http\Requests\Global\PageRequest;
use App\Http\Resources\API\ProductResource;
use App\Filters\Global\JsonDisplayNameFilter;

class ProductController extends Controller
{
    public function index(PageRequest $request): JsonResponse
    {
        $query = app(Pipeline::class)
            ->send(Product::with('files'))
            ->through([NameFilter::class, OrderByFilter::class])
            ->thenReturn();

        return successResponse(fetchData($query, $request->pageSize, ProductResource::class));
    }

    public function show(Product $product): JsonResponse
    {
        return successResponse(new ProductResource($product->load(['files'])));
    }

    public function sliders(PageRequest $request): JsonResponse
    {
        $query = app(Pipeline::class)
            ->send(Slider::query())
            ->through([OrderByFilter::class])
            ->thenReturn();

        return successResponse(fetchData($query, $request->pageSize, SliderResource::class));
    }
}
