<?php

namespace App\Http\Controllers\API\Web;

use App\Filters\Global\NameFilter;
use App\Filters\Global\OrderByFilter;
use App\Http\Controllers\Controller;
use App\Http\Requests\Global\PageRequest;
use App\Http\Resources\API\Category\CategoryResource;
use App\Models\Category;
use Illuminate\Http\JsonResponse;
use Illuminate\Pipeline\Pipeline;

class CategoryController extends Controller
{
    public function index(PageRequest $request): JsonResponse
    {
        $query = app(Pipeline::class)
            ->send(Category::with('products.files'))
            ->through([NameFilter::class, OrderByFilter::class])
            ->thenReturn();

        return successResponse(fetchData($query, $request->pageSize, CategoryResource::class));
    }

    public function show(Category $category): JsonResponse
    {
        return successResponse(new CategoryResource($category->load(['products.files'])));
    }
}
