<?php

namespace App\Http\Controllers\API\Order;

use App\Models\Order;
use App\Models\OrderNoteHistory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\Order\OrderNoteHistoryResource;

class OrderNoteController extends Controller
{
    /**
     * Add a note to the order history.
     */
    public function addNote(Request $request, Order $order)
    {
        $request->validate([
            'note' => 'required|string',
            'type' => 'nullable|string|in:system,client,admin', // Validate note type
        ]);

        $note = $order->noteHistory()->create([
            'note' => $request->note,
            'type' => $request->type ?? 'system', // Default to 'system' if not provided
            'user_id' => auth()->id(), // Attach the authenticated user (if applicable)
        ]);

        return successResponse(new OrderNoteHistoryResource($note), 'Note added successfully');
    }

    /**
     * Get all notes for an order.
     */
    public function getNotes(Order $order)
    {
        $notes = $order->noteHistory()->latest()->get();
        return successResponse(OrderNoteHistoryResource::collection($notes), 'Notes retrieved successfully');
    }
}
