<?php

namespace App\Http\Controllers\API\Customer;


use App\Models\Customer;
use App\Models\CustomerAddress;
use Illuminate\Http\JsonResponse;
use Illuminate\Pipeline\Pipeline;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Filters\Global\OrderByFilter;
use App\Http\Requests\Global\PageRequest;
use App\Http\Requests\Global\DeleteAllRequest;
use App\Http\Requests\API\Customer\CustomerRequest;
use App\Http\Resources\API\Customer\CustomerResource;



class CustomerController extends Controller
{

    public function index(PageRequest $request): JsonResponse
    {
        $query = app(Pipeline::class)
            ->send(Customer::query())
            ->through([OrderByFilter::class])
            ->thenReturn();
        return successResponse(fetchData($query, $request->pageSize, CustomerResource::class));
    }

    public function store(CustomerRequest $request): JsonResponse
    {
        // Create Customer
        $customer = Customer::create($request->validated());
        return successResponse(new CustomerResource($customer), __('api.created_success'));
    }

    public function show(Customer $customer): JsonResponse
    {
        return successResponse(new CustomerResource($customer));
    }

    public function update(CustomerRequest $request, Customer $customer): JsonResponse
    {
        // Update Customer details
        $customer->update($request->validated());
        return successResponse(new CustomerResource($customer), __('api.updated_success'));
    }

    public function destroy(Customer $customer): JsonResponse
    {
        $customer->delete();
        return successResponse(msg: __('api.deleted_success'));
    }

    public function destroyAll(DeleteAllRequest $request): JsonResponse
    {
        Customer::whereIn('id', $request->ids)->delete();
        return successResponse(msg: __('api.deleted_success'));
    }

}