<?php

namespace App\Filters\Global\Setting;

use Closure;

class KeyFilter
{
    public function handle($request, Closure $next)
    {
        $query = $next($request);

        $query->when(
            request()?->has('key') && !empty(request('key')),
            fn($q) => $q->where('key', request('key'))
        );

        return $query;
    }
}
