<?php

namespace App\Filters\Global\Setting;

use Closure;

class GroupFilter
{
    public function handle($request, Closure $next)
    {
        $query = $next($request);

        $query->when(
            request()?->has('group') && !empty(request('group')),
            fn($q) => $q->where('group', request('group'))
        );

        return $query;
    }
}
